#include <cstdio>
#include <iostream>
#include <string>
#include <vector>
#include <algorithm>
#include <cmath>
#include <cassert>
#include <memory.h>
#include <queue>
#include <deque>
#include <stack>
#include <list>
#include <map>
#include <set>
#include <functional>
#include <cstring>
#include <ctime>

using namespace std;

#define all(a) a.begin(), a.end()
#define mp make_pair

typedef long long li;
typedef long double ld;
typedef pair<int, int> pi;
typedef vector<int> vi;

#define FILENAME ""

void solve();
int main() {
#ifdef YA
	string s = FILENAME;
	//assert(!s.empty());
	clock_t start = clock();
	freopen("input.txt", "r", stdin);
	//freopen("output.txt", "w", stdout);
#else
	//freopen(FILENAME ".in", "r", stdin);
	//freopen(FILENAME ".out", "w", stdout);
	//freopen("input.txt", "r", stdin);
	//freopen("output.txt", "w", stdout);
#endif
	cout.sync_with_stdio(0);
	cin.tie(0);
	cout.precision(15);
	cout << fixed;

	int t = 1;
	//cin >> t;
	while(true) {
		solve();
	}
#ifdef YA
	cout << "\n\n" << (clock() - start) / 1.0 / CLOCKS_PER_SEC << "\n\n";
#endif
	return 0;
}


//#define int li

int n;
ld pw;
ld vw[100500], pf[100500], vf[100500], th[100500];

int state[100500];

void solve() {
	cin >> n;
	if (n == 0)
		exit(0);
	cin >> pw;
	for (int i = 0; i < n; ++i)
		cin >> vw[i] >> pf[i] >> vf[i] >> th[i];

	vector<pair<ld, int>> events;

	for (int i = 0; i < n; ++i) {
		if (vw[i] == 0)
			continue;
		ld cur = th[i] / 1.0 / vw[i];
		if (cur < 0)
			continue;
		events.push_back(mp(cur, i));
	}

	memset(state, 0, sizeof state);

	for (int i = 0; i < n; ++i) {
		ld eps = 1e-9;
		ld cur = th[i] + eps * vw[i];
		if (cur < 0)
			state[i] = 1;
		else
			state[i] = 2;
	}

	ld a = pw, b = 0;

	for (int i = 0; i < n; ++i)
		if (state[i] == 2) {
			a -= vw[i] * pf[i] / 1.0 / vf[i];
			b += th[i] * pf[i] / 1.0 / vf[i];
		}

	ld ans = b;

	sort(all(events));

	for (int i = 0; i < events.size(); ++i) {
		int cur = events[i].second;
		if (state[cur] == 2) {
			a += vw[i] * pf[i] / 1.0 / vf[i];
			b -= th[i] * pf[i] / 1.0 / vf[i];
			state[cur] = 1;
		}
		else {
			a -= vw[i] * pf[i] / 1.0 / vf[i];
			b += th[i] * pf[i] / 1.0 / vf[i];
			state[cur] = 2;
		}

		ans = min(ans, a * events[i].first + b);

		if (i + 1 < events.size())
			ans = min(ans, a * events[i + 1].first + b);
	}

	cout << ans << "\n";

}